---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-OPFS SAHPool テスト画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/tests/opfs/sahpool/index.html` - メインHTMLファイル
- E-02: `ext/wasm/tests/opfs/sahpool/sahpool-pausing.js` - テスト制御スクリプト
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.16）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SAHPool VFSのpause/unpause機能テスト | E-01 行14-18, E-02 行14-17 | ○ |
| C-02 | 2つのWorker（W1, W2）を使用 | E-02 行138-139 | ○ |
| C-03 | 両Worker初期化後にテスト開始 | E-02 行172-175 initCount===2 | ○ |
| C-04 | runPyramidOfDoomでコールバックチェーン | E-02 行119-133 | ○ |
| C-05 | postThenでメッセージ送信とコールバック登録 | E-02 行105-108 | ○ |
| C-06 | nextHandlerQueueでコールバック管理 | E-02 行98-103 | ○ |
| C-07 | W1: vfs-acquire → db-init → db-query → vfs-pause | E-02 行120-123 | ○ |
| C-08 | W2: vfs-acquire → db-query → vfs-remove | E-02 行124-127 | ○ |
| C-09 | 各種メッセージタイプの処理 | E-02 行145-177 switch文 | ○ |
| C-10 | endOfWorkでPASS/FAIL表示 | E-02 行83-96 | ○ |
| C-11 | tests-pass/tests-failクラスで色分け | E-02 行89, 93 | ○ |
| C-12 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行64 | ○ |
| C-13 | 機能No.43 OS抽象化層（VFS）が関連 | E-04 行65 | ○ |
| C-14 | 機能No.42 ミューテックスが関連 | E-04 行66 | ○ |
| C-15 | ログ逆順チェックボックスあり | E-01 行20-22 | ○ |
| C-16 | sahpool-worker.jsをWorkerとして使用 | E-02 行137 | ○ |
| C-17 | workerId=w1, w2を付与 | E-02 行140-141 | ○ |
| C-18 | error時はendOfWork(false)で失敗表示 | E-02 行168-169 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] W1がpause中にW2がVFSを取得できることを確認
- [ ] エラー発生時のFAIL表示が正しく動作するか確認
- [ ] sahpool-worker.jsが存在し正しく動作するか確認
